/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.Engine.engine;

import BryceMath.Geometry.Rectangle;
import Game_Engine.Engine.Objs.ImageB;
import Game_Engine.Engine.Objs.Obj_Container;
import Game_Engine.Engine.engine.Game_output;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.concurrent.CountDownLatch;
import javax.swing.Timer;

public class Game_looper {
    private Obj_Container root_container;
    private Timer updater;
    private Timer drawer;
    private Timer windower;
    public static int stepsElapsed = 0;
    private Game_output output;
    Rectangle DEFAULT_DRAW_REGION = null;
    Rectangle draw_region;
    public static boolean GUI_DRAW_ENABLED = false;
    BufferedImage frame_image;

    public Game_looper(Obj_Container data_in, int fps, Game_output out) {
        this.root_container = data_in;
        this.frame_image = new BufferedImage(this.root_container.getW(), this.root_container.getH(), 6);
        this.updater = new Timer(1000 / fps, new Update());
        this.drawer = new Timer(1000 / fps, new Drawer());
        this.output = out;
        this.setDrawingMode();
        this.drawAll();
        this.start();
    }

    private Rectangle drawAll() {
        this.draw_region = new Rectangle(0, 0, this.root_container.getW(), this.root_container.getH());
        return this.draw_region;
    }

    private void setDrawingMode() {
        if (this.DEFAULT_DRAW_REGION != null) {
            this.draw_region = this.DEFAULT_DRAW_REGION;
            return;
        }
        if (GUI_DRAW_ENABLED) {
            this.enterGuiDrawingMode();
        } else {
            this.enterFullAnimationMode();
        }
    }

    public void setData(Obj_Container data_in) {
        this.root_container = data_in;
    }

    public void start() {
        this.updater.start();
        this.drawer.start();
    }

    public void stop() {
        this.updater.stop();
        this.drawer.stop();
    }

    public void enterGuiDrawingMode() {
        this.DEFAULT_DRAW_REGION = null;
        this.draw_region = null;
    }

    public void enterFullAnimationMode() {
        this.DEFAULT_DRAW_REGION = this.drawAll();
    }

    public void addDrawingRegion(Rectangle r) {
        if (this.draw_region == null) {
            this.draw_region = r;
            return;
        }
        this.draw_region = this.draw_region.union(r);
    }

    public static int getElapsedSteps() {
        int output = stepsElapsed;
        stepsElapsed = 0;
        return output;
    }

    private class Drawer
    implements ActionListener {
        private Drawer() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CountDownLatch final_latch = new CountDownLatch(1);
            ImageB imageB = new ImageB(Game_looper.this.frame_image);
            if (Game_looper.this.draw_region == null) {
                return;
            }
            imageB = imageB.getSubImage(Game_looper.this.draw_region);
            Game_looper.this.draw_region = Game_looper.this.DEFAULT_DRAW_REGION;
            if (imageB == null) {
                return;
            }
            Graphics2D g = imageB.getGraphics();
            g.setColor(Game_looper.this.output.getColor());
            g.fillRect(0, 0, Game_looper.this.root_container.getW(), Game_looper.this.root_container.getH());
            Game_looper.this.root_container.draw(imageB, new AffineTransform(), final_latch);
            try {
                final_latch.await();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            Game_looper.this.output.draw(Game_looper.this.frame_image);
            if (stepsElapsed % 200 == 0) {
                System.gc();
            }
        }
    }

    private class Update
    implements ActionListener {
        private Update() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ++stepsElapsed;
            Game_looper.this.root_container.update();
        }
    }

    private class Windows
    implements WindowListener {
        private Windows() {
        }

        @Override
        public void windowActivated(WindowEvent arg0) {
            Game_looper.this.start();
            Game_looper.this.output.draw(Game_looper.this.frame_image);
        }

        @Override
        public void windowDeactivated(WindowEvent arg0) {
            Game_looper.this.stop();
        }

        @Override
        public void windowClosed(WindowEvent arg0) {
        }

        @Override
        public void windowClosing(WindowEvent arg0) {
        }

        @Override
        public void windowDeiconified(WindowEvent arg0) {
        }

        @Override
        public void windowIconified(WindowEvent arg0) {
        }

        @Override
        public void windowOpened(WindowEvent arg0) {
            Game_looper.this.start();
            Game_looper.this.output.draw(Game_looper.this.frame_image);
        }
    }
}

